(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      2681,         88]*)
(*NotebookOutlinePosition[      3323,        110]*)
(*  CellTagsIndexPosition[      3279,        106]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(F[x_, y_, 
        z_, \[Lambda]_] = \((x^3 + y^3 + 
            z^3)\) + \[Lambda]\ \((4  x^2 + 9  y^2 + 16  z^2 - 
              25)\)\)], "Input"],

Cell[BoxData[
    \(gradF[x_, y_, z_, \[Lambda]_] := {D[F[x, y, z, \[Lambda]], x], 
        D[F[x, y, z, \[Lambda]], y], D[F[x, y, z, \[Lambda]], z], 
        D[F[x, y, z, \[Lambda]], \[Lambda]]}\)], "Input"],

Cell[BoxData[
    \(pcritic = 
      Solve[gradF[x, y, z, \[Lambda]] \[Equal] {0, 0, 0, 0}, {x, y, 
          z, \[Lambda]}]\)], "Input"],

Cell[BoxData[
    \(Length[pcritic]\)], "Input"],

Cell[BoxData[
    \(pcritic[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(pcritic[\([1, 2]\)]\)], "Input"],

Cell[BoxData[
    \(pcriticxyz = Delete[pcritic, Table[{k, 1}, {k, 14}]]\)], "Input"],

Cell[BoxData[
    \(valores = 
      Table[x^3 + y^3 + z^3 /. pcriticxyz[\([k]\)], {k, 1, 14}]\)], "Input"],

Cell[BoxData[
    \(Max[valores]\)], "Input"],

Cell[BoxData[
    \(Min[valores]\)], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{610, 409},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 169, 4, 30, "Input"],
Cell[1877, 56, 208, 3, 50, "Input"],
Cell[2088, 61, 137, 3, 30, "Input"],
Cell[2228, 66, 48, 1, 30, "Input"],
Cell[2279, 69, 49, 1, 30, "Input"],
Cell[2331, 72, 52, 1, 30, "Input"],
Cell[2386, 75, 85, 1, 30, "Input"],
Cell[2474, 78, 107, 2, 30, "Input"],
Cell[2584, 82, 45, 1, 30, "Input"],
Cell[2632, 85, 45, 1, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

